/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.config;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import me.pepperbell.continuity.client.config.ContinuityConfig;
import me.pepperbell.continuity.client.config.Option;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_7919;

public class ContinuityConfigScreen
extends class_437 {
    private final class_437 parent;
    private final ContinuityConfig config;
    private List<Value<?>> values;

    public ContinuityConfigScreen(class_437 parent, ContinuityConfig config) {
        super((class_2561)class_2561.method_43471((String)ContinuityConfigScreen.getTranslationKey("title")));
        this.parent = parent;
        this.config = config;
    }

    protected void method_25426() {
        Value<Boolean> connectedTextures = Value.of(this.config.connectedTextures, Value.Flag.RELOAD_WORLD_RENDERER);
        Value<Boolean> emissiveTextures = Value.of(this.config.emissiveTextures, Value.Flag.RELOAD_WORLD_RENDERER);
        Value<Boolean> customBlockLayers = Value.of(this.config.customBlockLayers, Value.Flag.RELOAD_WORLD_RENDERER);
        this.values = List.of(connectedTextures, emissiveTextures, customBlockLayers);
        this.method_37063((class_364)this.startBooleanValueButton(connectedTextures).method_46434(this.field_22789 / 2 - 100 - 110, this.field_22790 / 2 - 10 - 12, 200, 20).method_46431());
        this.method_37063((class_364)this.startBooleanValueButton(emissiveTextures).method_46434(this.field_22789 / 2 - 100 + 110, this.field_22790 / 2 - 10 - 12, 200, 20).method_46431());
        this.method_37063((class_364)this.startBooleanValueButton(customBlockLayers).method_46434(this.field_22789 / 2 - 100 - 110, this.field_22790 / 2 - 10 + 12, 200, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, button -> {
            this.saveValues();
            this.method_25419();
        }).method_46434(this.field_22789 / 2 - 75 - 79, this.field_22790 - 40, 150, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24335, button -> this.method_25419()).method_46434(this.field_22789 / 2 - 75 + 79, this.field_22790 - 40, 150, 20).method_46431());
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 30, 0xFFFFFF);
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    private void saveValues() {
        EnumSet<Value.Flag> flags = EnumSet.noneOf(Value.Flag.class);
        for (Value<?> value : this.values) {
            if (!value.isChanged()) continue;
            value.saveToOption();
            flags.addAll(value.getFlags());
        }
        this.config.save();
        for (Value.Flag flag : flags) {
            flag.onSave();
        }
    }

    private static String getTranslationKey(String optionKey) {
        return "options.continuity." + optionKey;
    }

    private static String getTooltipKey(String translationKey) {
        return translationKey + ".tooltip";
    }

    private class_4185.class_7840 startBooleanValueButton(Value<Boolean> value) {
        String translationKey = ContinuityConfigScreen.getTranslationKey(value.getOption().getKey());
        class_5250 text = class_2561.method_43471((String)translationKey);
        class_5250 tooltipText = class_2561.method_43471((String)ContinuityConfigScreen.getTooltipKey(translationKey));
        return class_4185.method_46430((class_2561)class_5244.method_32700((class_2561)text, (class_2561)class_5244.method_36134((boolean)value.get())), arg_0 -> ContinuityConfigScreen.lambda$startBooleanValueButton$3(value, (class_2561)text, arg_0)).method_46436(class_7919.method_47407((class_2561)tooltipText));
    }

    private static /* synthetic */ void lambda$startBooleanValueButton$3(Value value, class_2561 text, class_4185 button) {
        boolean newValue = (Boolean)value.get() == false;
        value.set(newValue);
        class_2561 valueText = class_5244.method_36134((boolean)newValue);
        if (value.isChanged()) {
            valueText = valueText.method_27661().method_27694(style -> style.method_10982(Boolean.valueOf(true)));
        }
        button.method_25355((class_2561)class_5244.method_32700((class_2561)text, (class_2561)valueText));
    }

    private static class Value<T> {
        private final Option<T> option;
        private final Set<Flag> flags;
        private final T originalValue;
        private T value;

        public Value(Option<T> option, Set<Flag> flags) {
            this.option = option;
            this.flags = flags;
            this.originalValue = this.option.get();
            this.value = this.originalValue;
        }

        public static <T> Value<T> of(Option<T> option, Flag ... flags) {
            EnumSet<Flag> flagSet = EnumSet.noneOf(Flag.class);
            Collections.addAll(flagSet, flags);
            return new Value<T>(option, flagSet);
        }

        public Option<T> getOption() {
            return this.option;
        }

        public Set<Flag> getFlags() {
            return this.flags;
        }

        public T get() {
            return this.value;
        }

        public void set(T value) {
            this.value = value;
        }

        public boolean isChanged() {
            return !this.value.equals(this.originalValue);
        }

        public void saveToOption() {
            this.option.set(this.value);
        }

        public static enum Flag {
            RELOAD_WORLD_RENDERER{

                @Override
                public void onSave() {
                    class_310.method_1551().field_1769.method_3279();
                }
            };


            public abstract void onSave();
        }
    }
}

