/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.model;

import java.util.function.Predicate;
import java.util.function.Supplier;
import me.pepperbell.continuity.api.client.EmissiveSpriteApi;
import me.pepperbell.continuity.client.config.ContinuityConfig;
import me.pepperbell.continuity.client.model.ModelObjectsContainer;
import me.pepperbell.continuity.client.util.QuadUtil;
import me.pepperbell.continuity.client.util.RenderUtil;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.fabricmc.fabric.api.renderer.v1.material.MaterialFinder;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableMesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadTransform;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_10200;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_4696;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class EmissiveBakedModel
extends class_10200 {
    protected static final RenderMaterial[] EMISSIVE_MATERIALS;
    protected static final RenderMaterial DEFAULT_EMISSIVE_MATERIAL;
    protected static final RenderMaterial CUTOUT_MIPPED_EMISSIVE_MATERIAL;

    public EmissiveBakedModel(class_1087 wrapped) {
        super(wrapped);
    }

    public void emitBlockQuads(QuadEmitter emitter, class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, Predicate<@Nullable class_2350> cullTest) {
        if (!((Boolean)ContinuityConfig.INSTANCE.emissiveTextures.get()).booleanValue()) {
            super.emitBlockQuads(emitter, blockView, state, pos, randomSupplier, cullTest);
            return;
        }
        ModelObjectsContainer container = ModelObjectsContainer.get();
        if (!container.featureStates.getEmissiveTexturesState().isEnabled()) {
            super.emitBlockQuads(emitter, blockView, state, pos, randomSupplier, cullTest);
            return;
        }
        EmissiveBlockQuadTransform quadTransform = container.emissiveBlockQuadTransform;
        if (quadTransform.isActive()) {
            super.emitBlockQuads(emitter, blockView, state, pos, randomSupplier, cullTest);
            return;
        }
        MutableMesh mutableMesh = container.mutableMesh;
        quadTransform.prepare(mutableMesh.emitter(), state, cullTest);
        emitter.pushTransform((QuadTransform)quadTransform);
        super.emitBlockQuads(emitter, blockView, state, pos, randomSupplier, cullTest);
        emitter.popTransform();
        mutableMesh.outputTo(emitter);
        mutableMesh.clear();
        quadTransform.reset();
    }

    public void emitItemQuads(QuadEmitter emitter, Supplier<class_5819> randomSupplier) {
        if (!((Boolean)ContinuityConfig.INSTANCE.emissiveTextures.get()).booleanValue()) {
            super.emitItemQuads(emitter, randomSupplier);
            return;
        }
        ModelObjectsContainer container = ModelObjectsContainer.get();
        if (!container.featureStates.getEmissiveTexturesState().isEnabled()) {
            super.emitItemQuads(emitter, randomSupplier);
            return;
        }
        EmissiveItemQuadTransform quadTransform = container.emissiveItemQuadTransform;
        if (quadTransform.isActive()) {
            super.emitItemQuads(emitter, randomSupplier);
            return;
        }
        MutableMesh mutableMesh = container.mutableMesh;
        quadTransform.prepare(mutableMesh.emitter());
        emitter.pushTransform((QuadTransform)quadTransform);
        super.emitItemQuads(emitter, randomSupplier);
        emitter.popTransform();
        mutableMesh.outputTo(emitter);
        mutableMesh.clear();
        quadTransform.reset();
    }

    public boolean isVanillaAdapter() {
        if (!((Boolean)ContinuityConfig.INSTANCE.emissiveTextures.get()).booleanValue()) {
            return super.isVanillaAdapter();
        }
        return false;
    }

    static {
        BlendMode[] blendModes = BlendMode.values();
        EMISSIVE_MATERIALS = new RenderMaterial[blendModes.length];
        MaterialFinder finder = RenderUtil.getMaterialFinder();
        for (BlendMode blendMode : blendModes) {
            EmissiveBakedModel.EMISSIVE_MATERIALS[blendMode.ordinal()] = finder.emissive(true).disableDiffuse(true).ambientOcclusion(TriState.FALSE).blendMode(blendMode).find();
        }
        DEFAULT_EMISSIVE_MATERIAL = EMISSIVE_MATERIALS[BlendMode.DEFAULT.ordinal()];
        CUTOUT_MIPPED_EMISSIVE_MATERIAL = EMISSIVE_MATERIALS[BlendMode.CUTOUT_MIPPED.ordinal()];
    }

    protected static class EmissiveBlockQuadTransform
    implements QuadTransform {
        protected QuadEmitter emitter;
        protected class_2680 state;
        protected Predicate<@Nullable class_2350> cullTest;
        protected boolean active;
        protected boolean calculateDefaultLayer;
        protected boolean isDefaultLayerSolid;

        protected EmissiveBlockQuadTransform() {
        }

        public boolean transform(MutableQuadView quad) {
            if (this.cullTest.test(quad.cullFace())) {
                return false;
            }
            class_1058 sprite = RenderUtil.getSpriteFinder().find((QuadView)quad);
            class_1058 emissiveSprite = EmissiveSpriteApi.get().getEmissiveSprite(sprite);
            if (emissiveSprite != null) {
                RenderMaterial emissiveMaterial;
                this.emitter.copyFrom((QuadView)quad);
                BlendMode blendMode = quad.material().blendMode();
                if (blendMode == BlendMode.DEFAULT) {
                    if (this.calculateDefaultLayer) {
                        this.isDefaultLayerSolid = class_4696.method_23679((class_2680)this.state) == class_1921.method_23577();
                        this.calculateDefaultLayer = false;
                    }
                    emissiveMaterial = this.isDefaultLayerSolid ? CUTOUT_MIPPED_EMISSIVE_MATERIAL : DEFAULT_EMISSIVE_MATERIAL;
                } else {
                    emissiveMaterial = blendMode == BlendMode.SOLID ? CUTOUT_MIPPED_EMISSIVE_MATERIAL : EMISSIVE_MATERIALS[blendMode.ordinal()];
                }
                this.emitter.material(emissiveMaterial);
                QuadUtil.interpolate((MutableQuadView)this.emitter, sprite, emissiveSprite);
                this.emitter.emit();
            }
            return true;
        }

        public boolean isActive() {
            return this.active;
        }

        public void prepare(QuadEmitter emitter, class_2680 state, Predicate<@Nullable class_2350> cullTest) {
            this.emitter = emitter;
            this.state = state;
            this.cullTest = cullTest;
            this.active = true;
            this.calculateDefaultLayer = true;
            this.isDefaultLayerSolid = false;
        }

        public void reset() {
            this.emitter = null;
            this.state = null;
            this.cullTest = null;
            this.active = false;
        }
    }

    protected static class EmissiveItemQuadTransform
    implements QuadTransform {
        protected QuadEmitter emitter;
        protected boolean active;

        protected EmissiveItemQuadTransform() {
        }

        public boolean transform(MutableQuadView quad) {
            class_1058 sprite = RenderUtil.getSpriteFinder().find((QuadView)quad);
            class_1058 emissiveSprite = EmissiveSpriteApi.get().getEmissiveSprite(sprite);
            if (emissiveSprite != null) {
                this.emitter.copyFrom((QuadView)quad);
                this.emitter.material(DEFAULT_EMISSIVE_MATERIAL);
                QuadUtil.interpolate((MutableQuadView)this.emitter, sprite, emissiveSprite);
                this.emitter.emit();
            }
            return true;
        }

        public boolean isActive() {
            return this.active;
        }

        public void prepare(QuadEmitter emitter) {
            this.emitter = emitter;
            this.active = true;
        }

        public void reset() {
            this.emitter = null;
            this.active = false;
        }
    }
}

