/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.mixin.features.textures.mipmaps;

import net.caffeinemc.mods.sodium.api.util.ColorABGR;
import net.caffeinemc.mods.sodium.client.util.color.ColorSRGB;
import net.minecraft.class_4725;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={class_4725.class})
public class MipmapGeneratorMixin {
    @Overwrite
    private static int method_24101(int one, int two, int three, int four, boolean checkAlpha) {
        return MipmapGeneratorMixin.weightedAverageColor(MipmapGeneratorMixin.weightedAverageColor(one, two), MipmapGeneratorMixin.weightedAverageColor(three, four));
    }

    @Unique
    private static int weightedAverageColor(int one, int two) {
        int alphaTwo;
        int alphaOne = ColorABGR.unpackAlpha(one);
        if (alphaOne == (alphaTwo = ColorABGR.unpackAlpha(two))) {
            return MipmapGeneratorMixin.averageRgb(one, two, alphaOne);
        }
        if (alphaOne == 0) {
            return two & 0xFFFFFF | alphaTwo >> 2 << 24;
        }
        if (alphaTwo == 0) {
            return one & 0xFFFFFF | alphaOne >> 2 << 24;
        }
        float scale = 1.0f / (float)(alphaOne + alphaTwo);
        float relativeWeightOne = (float)alphaOne * scale;
        float relativeWeightTwo = (float)alphaTwo * scale;
        float oneR = ColorSRGB.srgbToLinear(ColorABGR.unpackRed(one)) * relativeWeightOne;
        float oneG = ColorSRGB.srgbToLinear(ColorABGR.unpackGreen(one)) * relativeWeightOne;
        float oneB = ColorSRGB.srgbToLinear(ColorABGR.unpackBlue(one)) * relativeWeightOne;
        float twoR = ColorSRGB.srgbToLinear(ColorABGR.unpackRed(two)) * relativeWeightTwo;
        float twoG = ColorSRGB.srgbToLinear(ColorABGR.unpackGreen(two)) * relativeWeightTwo;
        float twoB = ColorSRGB.srgbToLinear(ColorABGR.unpackBlue(two)) * relativeWeightTwo;
        float linearR = oneR + twoR;
        float linearG = oneG + twoG;
        float linearB = oneB + twoB;
        int averageAlpha = alphaOne + alphaTwo >> 1;
        return ColorSRGB.linearToSrgb(linearR, linearG, linearB, averageAlpha);
    }

    @Unique
    private static int averageRgb(int a, int b, int alpha) {
        float ar = ColorSRGB.srgbToLinear(ColorABGR.unpackRed(a));
        float ag = ColorSRGB.srgbToLinear(ColorABGR.unpackGreen(a));
        float ab = ColorSRGB.srgbToLinear(ColorABGR.unpackBlue(a));
        float br = ColorSRGB.srgbToLinear(ColorABGR.unpackRed(b));
        float bg = ColorSRGB.srgbToLinear(ColorABGR.unpackGreen(b));
        float bb = ColorSRGB.srgbToLinear(ColorABGR.unpackBlue(b));
        return ColorSRGB.linearToSrgb((ar + br) * 0.5f, (ag + bg) * 0.5f, (ab + bb) * 0.5f, alpha);
    }
}

