/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.api.provider;

import com.misterpemodder.shulkerboxtooltip.ShulkerBoxTooltip;
import com.misterpemodder.shulkerboxtooltip.api.PreviewContext;
import com.misterpemodder.shulkerboxtooltip.api.PreviewType;
import com.misterpemodder.shulkerboxtooltip.api.ShulkerBoxTooltipApi;
import com.misterpemodder.shulkerboxtooltip.api.provider.PreviewProvider;
import com.misterpemodder.shulkerboxtooltip.impl.config.Configuration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.minecraft.class_9288;
import net.minecraft.class_9297;
import net.minecraft.class_9334;

public class BlockEntityPreviewProvider
implements PreviewProvider {
    private final int defaultMaxInvSize;
    private final boolean defaultCanUseLootTables;
    private final int defaultMaxRowSize;
    private final int defaultCompactMaxRowSize;

    public BlockEntityPreviewProvider(int defaultMaxInvSize, boolean defaultCanUseLootTables) {
        this.defaultMaxInvSize = defaultMaxInvSize;
        this.defaultCanUseLootTables = defaultCanUseLootTables;
        this.defaultMaxRowSize = 9;
        this.defaultCompactMaxRowSize = 0;
    }

    public BlockEntityPreviewProvider(int defaultMaxInvSize, boolean defaultCanUseLootTables, int defaultMaxRowSize) {
        this.defaultMaxInvSize = defaultMaxInvSize;
        this.defaultCanUseLootTables = defaultCanUseLootTables;
        this.defaultMaxRowSize = defaultMaxRowSize <= 0 ? 9 : defaultMaxRowSize;
        this.defaultCompactMaxRowSize = 0;
    }

    public BlockEntityPreviewProvider(int defaultMaxInvSize, boolean defaultCanUseLootTables, int defaultMaxRowSize, int defaultCompactMaxRowSize) {
        this.defaultMaxInvSize = defaultMaxInvSize;
        this.defaultCanUseLootTables = defaultCanUseLootTables;
        this.defaultMaxRowSize = defaultMaxRowSize <= 0 ? 9 : defaultMaxRowSize;
        this.defaultCompactMaxRowSize = defaultCompactMaxRowSize;
    }

    @Override
    public boolean shouldDisplay(PreviewContext context) {
        if (this.canUseLootTables() && context.stack().method_57826(class_9334.field_49626)) {
            return false;
        }
        return BlockEntityPreviewProvider.getItemCount(this.getInventory(context)) > 0;
    }

    @Override
    public boolean showTooltipHints(PreviewContext context) {
        return context.stack().method_57826(class_9334.field_49622);
    }

    @Override
    public List<class_1799> getInventory(PreviewContext context) {
        class_7225.class_7874 registries = context.registryLookup();
        class_9288 container = (class_9288)context.stack().method_57824(class_9334.field_49622);
        int invMaxSize = this.getInventoryMaxSize(context);
        class_2371 inv = class_2371.method_10213((int)invMaxSize, (Object)class_1799.field_8037);
        if (registries != null && container != null) {
            container.method_57492(inv);
        }
        return inv;
    }

    @Override
    public int getInventoryMaxSize(PreviewContext context) {
        return this.defaultMaxInvSize;
    }

    @Override
    public List<class_2561> addTooltip(PreviewContext context) {
        class_1799 stack = context.stack();
        class_9297 lootComponent = (class_9297)stack.method_57824(class_9334.field_49626);
        class_2583 style = class_2583.field_24360.method_10977(class_124.field_1080);
        if (this.canUseLootTables() && lootComponent != null) {
            return switch (ShulkerBoxTooltip.config.tooltip.lootTableInfoType) {
                case Configuration.LootTableInfoType.HIDE -> Collections.emptyList();
                case Configuration.LootTableInfoType.SIMPLE -> Collections.singletonList(class_2561.method_43471((String)"shulkerboxtooltip.hint.loot_table").method_10862(style));
                default -> Arrays.asList(class_2561.method_43471((String)"shulkerboxtooltip.hint.loot_table.advanced").method_10852((class_2561)class_2561.method_43470((String)": ")), class_2561.method_43470((String)(" " + String.valueOf(lootComponent.comp_2414().method_29177()))).method_10862(style));
            };
        }
        if (ShulkerBoxTooltipApi.getCurrentPreviewType(this.isFullPreviewAvailable(context)) == PreviewType.FULL) {
            return Collections.emptyList();
        }
        return BlockEntityPreviewProvider.getItemListTooltip(new ArrayList<class_2561>(), this.getInventory(context), style);
    }

    public static List<class_2561> getItemCountTooltip(List<class_2561> tooltip, @Nullable List<class_1799> items) {
        return BlockEntityPreviewProvider.getItemListTooltip(tooltip, items, class_2583.field_24360.method_10977(class_124.field_1080));
    }

    public static List<class_2561> getItemListTooltip(List<class_2561> tooltip, @Nullable List<class_1799> items, class_2583 style) {
        int itemCount = BlockEntityPreviewProvider.getItemCount(items);
        class_5250 text = itemCount > 0 ? class_2561.method_43469((String)"container.shulkerbox.contains", (Object[])new Object[]{itemCount}) : class_2561.method_43471((String)"container.shulkerbox.empty");
        tooltip.add((class_2561)text.method_10862(style));
        return tooltip;
    }

    @Override
    public int getMaxRowSize(PreviewContext context) {
        return this.defaultMaxRowSize;
    }

    @Override
    public int getCompactMaxRowSize(PreviewContext context) {
        return this.defaultCompactMaxRowSize;
    }

    public boolean canUseLootTables() {
        return this.defaultCanUseLootTables;
    }

    private static int getItemCount(@Nullable List<class_1799> items) {
        int itemCount = 0;
        if (items != null) {
            for (class_1799 stack : items) {
                if (stack.method_7909() == class_1802.field_8162) continue;
                ++itemCount;
            }
        }
        return itemCount;
    }
}

